//FILE: BMPEdit24.h
//definitons of the BMPImage class
//This class drives the CS 460 Image Editor




#if !defined BMPEDIT24_H

#define BMPEDIT24_H

////////////////////////////////////////////////////////////////////////////////////////



// Class BMPImage
// Contains data structures and functions for editing 24-bit RGB bitmaps


#include <afxtempl.h>	//for class CArray
#include <afxwin.h>		//Application Frameworks Header



class BMPImage {

public:
	
	// the two functions I added to Jake's code	
	COLORREF BMPGetColor(int x, int y);
	void BMPFileSetUp(long width, long height);
	
	
	
	BMPImage::BMPImage();	//constructor
	BMPImage::~BMPImage();	//destructor

	char ImgFile[80];		//string that contains the filename from which this object was created
	int saved;				// flag that marks current file as SAVED
	int altered;			// flag that indicates user image alterations
	int EDIT_FUNCTION;		// indicates which image editing function needs
							// to be called.....
	
	
	
	
	
	
	CDC * temp_dc;			//Pointer to a Windows Device Context used for 
							//backup storage of altered image data
							//This DC resides in memory only.....
	
	
	

	//BMPImage Member functions



	int  BMPRead(char ImgFile[80]);				//Reads image data from file
	void BMPWrite(char ImgFile[80], CDC * dc);	//Writes image data to specified file
	void BMPRedraw(CDC * dc);					//Redraws image on Main Window from temp_dc
	void BMPDraw(CDC * dc);						//Draws image on Main Window from original file data
	void BMPBrightnessUp(CDC * dc);				//Increases brightness of an image
	void BMPBrightnessDown(CDC * dc);			//Decreases brightness of an image
	void BMPContrastUp(CDC * dc);				//Increases contrast of an image
	void BMPContrastDown(CDC * dc);				//Decreases contrast of an image
	void BMPRedTintUp(CDC * dc);				//Increases the red component of all image pixels
	void BMPRedTintDown(CDC * dc);				//Decreases the rec component of all image pixels
	void BMPGreenTintUp(CDC * dc);				//Increases the green component of all image pixels
	void BMPGreenTintDown(CDC * dc);			//Decreases the green component of all image pixels
	void BMPBlueTintUp(CDC * dc);				//Increases the blue component of all image pixels
	void BMPBlueTintDown(CDC * dc);				//Decreases the blue component of all image pixels
	
	void BMPGrayScale(CDC * dc);				//Converts image to grayscale
	void BMPNegative(CDC * dc);					//Converts image to its negative
	void BMPRotate90(CDC * dc);					//Rotates image left 90 degrees
	void BMPMirror(CDC * dc);					//Mirrors the image horizontally
	void BMPZoomIn(CDC * dc);					//Zooms in on image 10%
	void BMPZoomOut(CDC * dc);					//Zooms out from image 10%

	// Non-editing functions

	LONG GetBMPWidth();							//Obtains Bitmap width in pixels
	LONG GetBMPHeight();						//Obtains Bitmap height in pixels
	void BMPCopyDC(CDC * s_dc, CDC *d_dc);		//Copies pixels from one DC to another
	int BMPGetStartX(LONG xwidth);				//Calculates starting X position for bitmaps
	int BMPGetStartY(LONG ywidth);				//Calculates starting Y position for bitmaps


	



protected:


// Bitmap data structure....

	 
// Bitmap File Header

		short     fhType;			//marks file as BITMAP

		DWORD     fhSize;			//Total size of file
		short     fhReserved1;		//reserved, usu. empty
		short     fhReserved2;		//empty
		DWORD     fhOffBits;		//Offset from the end of file header to start of image

	

	 
// Bitmap Info Header

		DWORD     ihSize;			//size of bitmap in Bytes
		LONG      ihWidth;			//Width of bitmap in pixels
		LONG      ihHeight;			//Height of bitmap in pixels
		WORD      ihPlanes;			//number of planes (usu. 1)
		WORD      ihBitCount;		//number of bits per pixel, should be 24
		DWORD     ihCompression;	//Flag marking bitmap as compressed, should be 0
		DWORD     ihSizeImage;		//Width x Height
		LONG      ihXPelsPerMeter;	//X-resolution
		LONG      ihYPelsPerMeter;	//Y-resolution
		DWORD     ihClrUsed;		//Number of colors used (for palette bitmaps only)
		DWORD     ihClrImportant;	//Number of colors crucial to quality of bitmap
									//used for palette bitmaps only

// Other Bitmap data....

		LONG OrigWidth;
		LONG OrigHeight;     //Stores original Height and Width of bitmap
							 // when image is resized....




	// scanline goes here...
typedef CArray<COLORREF, COLORREF&> CPixelArray;  //Array of COLORREF integers.
	//eacch colorref integer contains the red, green and blue components for one pixel

		
	CPixelArray ScanLine;   //Array of pixels representing one scan line 
	
	CArray<CPixelArray, CPixelArray&> ScanLineIndex; //Array of  scan lines 
	
	
	
};

#endif


/////////BMPEdit24.h 