/******************************************************************/
/*  Author: Alex Slusarek                                         */
/*                                                                */
/*  Function:  header file defining functions and variables used  */
/*             in the main source file (image.cpp)                */
/*                                                                */
/*  Input:  none                                                  */
/*                                                                */
/*  Output:  none                                                 */
/******************************************************************/

#include "BMPEdit24.h"  // include Jake's code

class CImageWin : public CFrameWnd {
public:


    CImageWin();
    ~CImageWin();

    afx_msg void OnPaint();  // used to refresh the window upon request
    afx_msg void OriginalImage();  // reverts picture back to original format
    afx_msg void ImageScaleSmoothBresenham();  // scales a picture
    afx_msg void ImageScaleBresenham();  // scales a picture
    afx_msg void ImageScaleCrudeBigger();  // scales a picture
    afx_msg void ImageScaleCrudeSmaller();  // scales a picture
    afx_msg void LastImage();  // reverts picture back to last format
    afx_msg void OnFileOpen ();  // opens a bmp file
    afx_msg void OnFileSaveAs ();  // saves a bmp file
    afx_msg int OnCreate (LPCREATESTRUCT lpsc);  // does things on window creation
    afx_msg void OnFileClose();  // closes down the program
   

    bool FileOpen;  // used to test if file has been opened
    bool FileChanged;  // used to test if picture has been saved

	// used for the timing of algorigthms
    long start, finish;
    double duration;

	// dimensions of specific color arrays
	// dimensions of specific pictures
    unsigned long LastHeight;
    unsigned long LastWidth;
    unsigned long OriginalHeight;
    unsigned long OriginalWidth;
    unsigned long CurrentHeight;
    unsigned long CurrentWidth;
	unsigned long CrudeHeight;
    unsigned long CrudeWidth;
	unsigned long SmoothHeight;
    unsigned long SmoothWidth;
	unsigned long BresenhamHeight;
    unsigned long BresenhamWidth;
	
	// bitmaps used to set dimensions
	// of each MemDC...
	CBitmap CurrentBitmap;
    CBitmap CrudeBitmap;
    CBitmap SmoothBitmap;
    CBitmap BresenhamBitmap;
    CDC CrudeMemDC;

	// specific MemDCs
	CDC CurrentMemDC;
    CDC TempMemDC;    
    CDC SmoothMemDC;
    CDC BresenhamMemDC;

	// pointers to dynamic 2D color arrays
    COLORREF ** OriginalColors;
    COLORREF ** CurrentColors;
    COLORREF ** CrudeColors;
    COLORREF ** SmoothColors;
    COLORREF ** BresenhamColors;
    COLORREF ** LastColors;
   
    BMPImage * image;   // pointer to BMPImage object...
    char filename[80];  // name of image file (.bmp )

    DECLARE_MESSAGE_MAP();
};

