/******************************************************************/
/*  Author: Alex Slusarek                                         */
/*                                                                */
/*  Function:  the modal dialog window that prompts the user for  */
/*             the new dimensions of the bresenham and smooth     */
/*             bresenham algorithms (both functions call this)    */
/*                                                                */
/*  Input:  parent window, current dimensions and a bool telling  */
/*          which function called it                              */
/*                                                                */
/*  Output:  messageboxes alerting user of any data errors        */
/******************************************************************/

#include <afxwin.h>
#include "SmoothDialog.h"
#include "ImageConstants.h"

/********************************************************************/
/*  Author: Alex Slusarek                                           */
/*                                                                  */
/*  Function:  constructs the modal dialog window to prompt the     */
/*             user                                                 */
/*                                                                  */
/*  Input:  a pointer to the parent window, the current dimensions  */
/*          and a bool depicting which function called it           */
/*          setup of window is predefined in image.rc               */
/*                                                                  */
/*  Output:  creates and displays modal dialog window               */
/********************************************************************/
SmoothDialog::SmoothDialog(LPCSTR n, CWnd * owner,
							   long Width, long Height, bool SmoothBresenham) :
						CDialog(n, owner)
{
	// set initial values
	OldWidth = Width;
	OldHeight = Height;

	NewWidth = OldWidth;
	NewHeight = OldHeight;

	CheckStatus = 0;

	IsSmooth = SmoothBresenham;

}  // SmoothDialog

/*****************************************************************/
/*  Author: Alex Slusarek                                        */
/*                                                               */
/*  Function:  deconstructor, takes care of garbage clean up     */
/*                                                               */
/*  Input:  none                                                 */
/*                                                               */
/*  Output:  none                                                */
/*****************************************************************/
SmoothDialog::~SmoothDialog()
{
}  //~SmoothDialog


/*****************************************************************/
/*  Author: Alex Slusarek                                        */
/*                                                               */
/*  Function:  sets the values of the edit and check boxes       */
/*                                                               */
/*  Input:  none, uses current dimension values                  */
/*                                                               */
/*  Output:  displays dialog window on screen with values set    */
/*****************************************************************/
BOOL SmoothDialog::OnInitDialog()
{

	// make base call to set everything up
	CDialog::OnInitDialog();

	// variables used
	char text[10];
	CEdit * p;

	// convert and set editboxes
	itoa(NewWidth, text, 10);
	p = (CEdit*)GetDlgItem(ID_WIDTH);
	p->SetWindowText(text);

	// with current dimensions
	itoa(NewHeight, text, 10);
	p = (CEdit*)GetDlgItem(ID_HEIGHT);
	p->SetWindowText(text);

	// set checkbox as unchecked
	CButton *pCButton = ( CButton * ) (GetDlgItem( ID_COLORAVERAGED ));
	pCButton->SetCheck(BST_UNCHECKED);

	// this should work, but crashes?...
	// if Bresenham Algorithm called this,
	// we do not need to show averaged pixels
	//if(IsSmooth) pCButton-> = false;

	return TRUE;

}  //OnInitDialog

/*****************************************************************/
/*  Author: Alex Slusarek                                        */
/*                                                               */
/*  Function:  returns the check status of the checkbox          */
/*                                                               */
/*  Input:  none, uses predefined ID of checkbox                 */
/*                                                               */
/*  Output:  returns check status of checkbox as int             */
/*****************************************************************/
int SmoothDialog::GetButtonStatus()
{
	// check status of button
	return CheckStatus;

}  //GetButtonStatus


/*****************************************************************/
/*  Author: Alex Slusarek                                        */
/*                                                               */
/*  Function:  gets the updated data, validates and returns to   */
/*             main program                                      */
/*                                                               */
/*  Input:  none                                                 */
/*                                                               */
/*  Output:  messageboxes alerting user of any data errors       */
/*****************************************************************/
void SmoothDialog::OnOK()
{	

	// get update data, and continue onwards..

	// variables used
	char text[10];
	CEdit * p;

	// get new width value
	p = (CEdit *)GetDlgItem(ID_WIDTH);
	p->GetWindowText(text,4);
	NewWidth = atoi(text);

	// validate data to assure it is within range
	if ((NewWidth >= (OldWidth * .667)) && (NewWidth <= (OldWidth * 2)))
	{
		// get new height value
		p = (CEdit *)GetDlgItem(ID_HEIGHT);
		p->GetWindowText(text,4);
		NewHeight = atoi(text);

		// validate data to assure it is within range
		if ((NewHeight >= (OldHeight * .667)) && (NewHeight <= (OldHeight * 2)))
		{
			// check for status of checkbox and update accordingly
			CButton *pCButton = ( CButton * ) (GetDlgItem(ID_COLORAVERAGED));
			CheckStatus = pCButton->GetCheck();

			// everything is a-OK, continue onwards...
			CDialog::OnOK();

		}  //if (NewHeight>=..)
		else  
		{
			// alert the user of their error and return them to it
			MessageBox("New Height is not in range of 2/3 to 2 times starting Height","Height Range Error!");
			p = (CEdit *)GetDlgItem(ID_HEIGHT);
			p->SetFocus();

		}  //else (NewHeight..)


	}  //if (NewWidth >=..)
	else  
	{
		// alert the user of their error and return them to it
		MessageBox("New Width is not in range of 2/3 to 2 times starting Width","Width Range Error!");
		p = (CEdit *)GetDlgItem(ID_WIDTH);
		p->SetFocus();

	}  //else (NewWidth..)

}  //OnOK


/*****************************************************************/
/*  Author: Alex Slusarek                                        */
/*                                                               */
/*  Function:  returns the new width                             */
/*                                                               */
/*  Input:  none                                                 */
/*                                                               */
/*  Output:  returns width dimension as a long                   */
/*****************************************************************/
long SmoothDialog::GetWidth() const
{ return NewWidth; }  //GetWidth


/*****************************************************************/
/*  Author: Alex Slusarek                                        */
/*                                                               */
/*  Function:  returns the new height                            */
/*                                                               */
/*  Input:  none                                                 */
/*                                                               */
/*  Output:  returns height dimension as a long                  */
/*****************************************************************/
long SmoothDialog::GetHeight() const
{ return NewHeight; }  //GetHeight



BEGIN_MESSAGE_MAP(SmoothDialog, CDialog)

END_MESSAGE_MAP()
