/******************************************************************/
/*  Author: Alex Slusarek                                         */
/*                                                                */
/*  Function:  header file defining functions and variables used  */
/*             in the modal dialog window source file             */
/*             (SmoothDialog.cpp)                                 */
/*                                                                */
/*  Input:  none                                                  */
/*                                                                */
/*  Output:  none                                                 */
/******************************************************************/

#ifndef SmoothDIALOG_H
#define SmoothDIALOG_H


class SmoothDialog : public CDialog
{
public:
	// constructor, makes the window
	SmoothDialog(LPCSTR n, CWnd * owner = 0, 
					long Width = 0, long Height = 0, bool SmoothBresenham = true);
	~SmoothDialog();  // deconstructor, garbage collection

	BOOL OnInitDialog();  // sets up initial values
	void OnOK();  // validates data entered by user

	long GetWidth() const;  // returns new width
	long GetHeight() const;  // returns new height

	int GetButtonStatus();  // returns checkbox status

private:

	// old dimensions specified in dialog window call
	long OldWidth;
	long OldHeight;

	// check button status variables
	int CheckStatus;
	bool IsSmooth;

	// new dimensions set when dialog window closes with IDOK
	long NewWidth;
	long NewHeight;
	

	DECLARE_MESSAGE_MAP()
};


#endif
