VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Image Scaling"
   ClientHeight    =   4575
   ClientLeft      =   60
   ClientTop       =   510
   ClientWidth     =   8940
   LinkTopic       =   "Form1"
   ScaleHeight     =   4575
   ScaleWidth      =   8940
   StartUpPosition =   3  'Windows Default
   Begin VB.PictureBox Picture3 
      Height          =   4215
      Left            =   3360
      ScaleHeight     =   4155
      ScaleWidth      =   5355
      TabIndex        =   0
      Top             =   120
      Width           =   5415
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Dim lwndC As Long     ' Handle to the video capture window
Private VideoData() As Byte         'Stores original Video frame bitmap w/o 'bmp' header
Private LastVideoData() As Byte     'Stores the last Video fram bitmap w/o 'bmp' header
Private BWAray(160, 120) As Integer    'stores the most recent b/w value for each pixel
Private BWLArray(160, 120) As Integer 'stores the last b/w value for each pixel
Private BWAArray(160, 120) As Integer 'stores b/w averages for each pixel
Dim picsize As Long
Dim newpic() As Byte
Dim crudewidth As Long
Dim crudeheight As Long

'======================================================================
'       bmp bitmap header format
'======================================================================

'***** 1st 14 bytes
Private Type BITMAPFILEHEADER
     bfType As Integer
     bfSize As Long
     bfReserved1 As Integer
     bfReserved2 As Integer
     bfOffBits As Long
End Type ' 14 bytes
    
'***** next 40 bytes  - header is 54 bytes total
Private Type BITMAPINFOHEADER
      biSize As Long
      biWidth As Long
      biHeight As Long
      biPlanes As Integer  ' 16 bits
      biBitCount As Integer ' 16 bits
      biCompression As Long
      biSizeImage As Long
      biXPelsPerMeter As Long
      biYPelsPerMeter As Long
      biClrUsed As Long
      biClrImportant As Long
End Type  ' 40 bytes
'======================================================================
'       END    bmp bitmap header format
'======================================================================




















Private Declare Sub ShowImage Lib "converts.dll" _
              (ByVal hwnd As Long, _
               ByRef databytes As Byte, _
               ByRef bmInfo As Byte, _
               ByVal x As Long, ByVal y As Long, _
               ByVal width As Long, ByVal height As Long)

Private Declare Function BuildDDBitmap Lib "converts.dll" _
              (ByVal hwnd As Long, _
               ByRef databytes As Byte, _
               ByRef bmInfo As Byte) As Long 'BITMAPINFOHEADER) As Long

Private Declare Function DeleteObject Lib "GDI32" ( _
                ByVal hbmp As Long) As Long



Dim datab1() As Byte   '  holds captured image data in 'bmp' format w/ header data

Dim bmpFileSize As Long
Dim imageOffSet As Long
Dim imageWidth As Long
Dim imageHeight As Long
Dim imageBitCount As Integer







Private Sub Form_Load()
    Dim lpszName As String * 100
    Dim lpszVer As String * 100
    Dim Caps As CAPDRIVERCAPS
    
    On Error GoTo err1

    '  params:
    '  1. handle for window, returned
    '  2. camera software name
    '  3. software version,
    '  4. horizontal image size
    '  5. vertical image size, '
    '  6. Prevew rate in MS
    '  7. should camera prevew to window?
    Call MyInitVideoStream(lwndC, lpszName, lpszVer, 160, 120, _
                           20, True) ' capture every 66 ms
                           
     Call capDlgVideoFormat(lwndC)
     Call ResizeCaptureWindow(lwndC)
crudewidth = 160 * 2 * 3
crudeheight = 120 * 2 * 3
Call BuildBmpHeader160
Exit Sub

err1:
   MsgBox "video image error"
End Sub



Function FrameCallback(ByVal lwnd As Long, ByVal lpVHdr As Long) As Long
       Dim VideoHeader As VIDEOHDR

        '//Fill VideoHeader with data at lpVHdr
        RtlMoveMemory VarPtr(VideoHeader), lpVHdr, Len(VideoHeader)
    
        '// Make room for image data based on size of data identified in video header
        ReDim VideoData(VideoHeader.dwBytesUsed)
'        ReDim LastVideoData(VideoHeader.dwBytesUsed)
 '           CopyMemory LastVideoData(0), VideoData(0), 57600
        
        '// Copy image data into the array
        RtlMoveMemory VarPtr(VideoData(0)), VideoHeader.lpData, VideoHeader.dwBytesUsed
     
        RtlMoveMemory VideoHeader.lpData, VarPtr(VideoData(0)), VideoHeader.dwBytesUsed
        
        Call HandleFrame(VideoHeader.dwBytesUsed)
        
End Function

Public Sub HandleFrame(BytesUsed As Long)
'************************************************************************
'Author:  Mainly Kevin Trost, Alex Slusarek modified this function to
'                              image scale streaming from a web cam
'*Handle Frame:
'
'   called by framecallback module
'
'*Oversees all handeling of each individual frame
'*Input: Global Variable VideoData
'*       BytesUsed number of bytes in VideoData
'*Output:Screen Output, frams from web cam twice as big
'************************************************************************
    Dim lWid As Integer  'logical width
    Dim lHi As Integer   'logical height
    Dim bWid As Integer  'byte width
    Dim bHi As Integer   'byte height

    If BytesUsed = 57600 Then
        'List1.AddItem " in 160x120 "
        lWid = 160
        lHi = 120
        bWid = 160 * 3
        bHi = 120 * 3
    Else
        Beep
        Exit Sub
    End If
    
    'make array to size i need
    ReDim newpic(crudewidth * crudeheight) As Byte
    
    'all the variables i need
    Dim b As Byte
    Dim g As Byte
    Dim r As Byte
    Dim x As Long
    Dim y As Long
    Dim i As Long
    Dim top As Long
    Dim bottom As Long
    Dim offset As Long

    'initialize for start
    offset = 0
    top = 0
    bottom = crudewidth


    'run through entire array of data
    Do While i <= (BytesUsed - 2)
        
        'get colors of current pixel
        b = VideoData(i)
        g = VideoData(i + 1)
        r = VideoData(i + 2)
        
        'set colors to four new pixels
        newpic(top + offset) = b
        newpic(top + offset + 1) = g
        newpic(top + offset + 2) = r
        
        newpic(top + offset + 3) = b
        newpic(top + offset + 4) = g
        newpic(top + offset + 5) = r
        
        newpic(bottom + offset) = b
        newpic(bottom + offset + 1) = g
        newpic(bottom + offset + 2) = r
        
        newpic(bottom + offset + 3) = b
        newpic(bottom + offset + 4) = g
        newpic(bottom + offset + 5) = r
        
        'increment through "array"
        x = x + 1
        
        'we've reached the rows end, start over
        If x >= lWid Then
            x = 0
            
            'move to next rows in new array
            top = top + (2 * crudewidth)
            bottom = bottom + (2 * crudewidth)
            
            'move height up one
            y = y - 1
            
            'reset for next round
            offset = 0
        End If
        
        'move pointer through old array
        i = i + 3
        
        'move pointer through new array
        offset = offset + 6
    Loop 'do while

    'variables used to display picture
    Dim y1 As Integer
    Dim x1 As Integer
    
    'setup picture frame for viewing
    Picture3.ScaleMode = vbPixels
    
    'size of picture
    picsize = crudewidth * crudeheight
    
    'initialize for loop
    y1 = crudeheight / 3
    i = 0
    
    Do While i <= (crudewidth * crudeheight - 2)
        
        'set each pixel with data from array
        Picture3.PSet (x1, y1), RGB(newpic(i + 2), newpic(i + 1), newpic(i))
        
        'end of the row, start a new one
        If x1 >= crudewidth / 3 Then
            x1 = 0
            y1 = y1 - 1
        End If
        
        'move to next pixel in array
        i = i + 3
        x1 = x1 + 1
    Loop  'do while
    

End Sub
























Private Sub DisplayImage(winHandle As Long)
'   Dim hbmp1 As Long
   
   '  datab1(14) beginning of bmpInfoHeader
'   hbmp1 = BuildDDBitmap(Form1.hwnd, datab1(imageOffSet), datab1(14)) 'bmInfo1)
   
   'Picture2.Cls
   Call ShowImage(winHandle, datab1(imageOffSet), datab1(14), 0, 0, -1, -1)
'   Call DeleteObject(hbmp1)
   
End Sub

Private Sub BuildBmpHeader160()
'********************************************************
'   Builds the header records (2)  for a bmp file or bmp
'   bit map.  Assumes a picture size of 160 x 120
'   Builds it into "datab1"
'********************************************************
   Dim i As Integer
   Dim biSize As Long
   Dim biSizeImage As Long
   Dim biPlanes As Integer
   Dim biBitCount As Long
   Dim biComp As Integer
        
   imageWidth = 160
   imageHeight = 120
   imageOffSet = 54
   bmpFileSize = crudewidth * crudeheight + imageOffSet
        
   ReDim datab1(bmpFileSize) As Byte
        
   For i = 0 To 54 - 1
      datab1(i) = 0
   Next i
   
   datab1(0) = Asc("B")
   datab1(1) = Asc("M")
        
   Call RtlMoveMemory(VarPtr(datab1(2)), VarPtr(bmpFileSize), 4)
   Call RtlMoveMemory(VarPtr(datab1(10)), VarPtr(imageOffSet), 4)
   
   biSize = 40
   Call RtlMoveMemory(VarPtr(datab1(14)), VarPtr(biSize), 4)
        
   Call RtlMoveMemory(VarPtr(datab1(18)), VarPtr(crudewidth), 4)
   Call RtlMoveMemory(VarPtr(datab1(22)), VarPtr(crudeheight), 4)
        
   biPlanes = 1
   Call RtlMoveMemory(VarPtr(datab1(26)), VarPtr(biPlanes), 2)

   biBitCount = 24
   Call RtlMoveMemory(VarPtr(datab1(28)), VarPtr(biBitCount), 4)

   biComp = 0
   Call RtlMoveMemory(VarPtr(datab1(32)), VarPtr(biComp), 2)

   biSizeImage = crudewidth * crudeheight
   Call RtlMoveMemory(VarPtr(datab1(34)), VarPtr(biSizeImage), 4)
        
End Sub





